## 概述
随着业务规模和复杂性的不断增长，分布式计算成为了数据持久化、运算高性能的必要选择，然而，分布式多机器、多集群的协作成为了一个问题，如何让规模巨大的多机器甚至多个集群协同工作呢？又如何避免集群中单台机器的增加、删除、变动而对集群造成的巨大影响呢？

解决问题的方法就是抽象化的分布式架构，通过代理的方式让客户端与服务端解耦，使各种突发事件能够被透明化的解决，同时，服务的调用者期望服务对他而言足够简单，最好是像调用本地服务一样简单，各种分布式架构应运而生，Broker 就是其中的一个

## Broker 的组成
Broker 体系结构拥有六个组成部分：

1. Client -- 需要访问远程服务的客户端
2. Server -- 服务的提供者
3. Broker -- 类似于消息的转发器，负责控制和管理集群，Server 启动时向 Broker 注册，从而 Broker 在接到 Client 的消息后可以得知要将消息转发给哪个 Server，然后在 Server 做出应答或发生异常后再将回应通知给 Client
4. Client_Proxy -- Client 端的代理层，对 Client 隐藏连接、通讯等底层服务，让 Client 在使用远程服务时如同使用本地服务一样简单，他维系了 Client 与 Broker 的通信和连接
5. Server_Proxy -- Server 端的代理曾，同样，他接收请求、解包消息，让 Server 与 Broker 的通信和连接被隐藏
6. Bridge -- 用于多个集群的复杂网络，协调多个 Broker 的数据、消息等工作


## Broker 的优缺点
#### 优点
无论是远程服务的访问还是消息的获取、通信，Broker 提供了代理完成了很高程度的抽象，让 Client 和 Server 的设计者更加关注于业务，而无需考虑底层的实现、通信参数的选取等问题

同时，由于模块化、抽象化，让整个架构各组件之间耦合度很低，Server 注册即可用，大大增加了可伸缩性、可维护性，动态扩展变得简单而高效

 
#### 缺点
显而易见的，整套架构的复杂度很高，在实际的生产环境中，Broker 怎么及时发现意外断开的 Server，如何实现负载均衡都是需要考虑的问题

同时，由于高度的组件化，多了 Broker 的消息转发，让 Client 与 Server 的交互效率有所下降

## Broker 的应用
在复杂的系统设计中，Client 和 Server 都有自己的 Broker，Client 的 Broker 收到消息后首先通过 Bridge 找到可以处理消息的 Server 的 Broker 然后再将消息通过 Bridge 发送给 Server 的 Broker

这样的搞复杂度让整个架构过于庞大，除非分布式计算任务太过复杂，通常使用者都会对这个架构做出不同程度的简化，比如 Client、Server 公用一个或多个 Broker、去除 Bridge、统一跨平台通信协议等

Broker 已经被用于 RabbitMQ、kafka 等多个成熟的开源框架 